<?php get_header(); ?>


<?php if ( have_posts() ) : ?>

    <?php /* Start the Loop */ ?>
    <?php while ( have_posts() ) : the_post(); ?>
        
        <h1><?php the_title(); ?></h1>

        <?php

        # Breadcrumb для постов
        $parentCategory = get_the_category();

        if ($parentCategory[0]->slug == 'news') {

            echo '<div id="breadcrumbs">
                    <a href="' . get_bloginfo('url') . '" title="Английский язык">Главная</a>
                    <span>&raquo;</span>
                    <a href="' . get_bloginfo('url') . '/news/" title="Новости английского языка">Новости</a>
                    <span>&raquo;</span>' .
                    get_the_title() .
                '</div>';
        }

        if ($parentCategory[0]->slug == 'articles') {

            echo '<div id="breadcrumbs">
                    <a href="' . get_bloginfo('url') . '" title="Английский язык">Главная</a>
                    <span>&raquo;</span>
                    <a href="' . get_bloginfo('url') . '/articles/" title="Статьи">Статьи</a>
                    <span>&raquo;</span>' .
                    get_the_title() .
                '</div>';
        }

        if ($parentCategory[0]->slug == 'idioms') {

            echo '<div id="breadcrumbs">
                    <a href="' . get_bloginfo('url') . '" title="Английский язык">Главная</a>
                    <span>&raquo;</span>
                    <a href="' . get_bloginfo('url') . '/idioms/" title="Английские идиомы">Английские идиомы</a>
                    <span>&raquo;</span>' .
                    get_the_title() .
                '</div>';
        }

        if ($parentCategory[0]->slug == 'topics') {

            echo '<div id="breadcrumbs">
                    <a href="' . get_bloginfo('url') . '" title="Английский язык">Главная</a>
                    <span>&raquo;</span>
                    <a href="' . get_bloginfo('url') . '/topics/" title="Английские темы / Английские топики">Английские темы</a>
                    <span>&raquo;</span>' .
                    get_the_title() .
                '</div>';
        }

        ?>

        <?php
        # page is child of page 'grammar'
        if (is_grandchild('2')) {

            $parent = get_pages(array('include' => $post->post_parent));

            echo '<div id="breadcrumbs">
                    <a href="' . get_bloginfo('url') . '" title="Английский язык">Главная</a>
                    <span>&raquo;</span>
                    <a href="' . get_bloginfo('url') . '/grammar/" title="Английская грамматика">Грамматика</a>
                    <span>&raquo;</span>
                    <a href="' . get_bloginfo('url') . '/grammar#' . $parent[0]->post_name . '" title="' . $parent[0]->post_title . '">' . $parent[0]->post_title . '</a>
                    <span>&raquo;</span>' . 
                    get_the_title() .
                '</div>';
            # the_permalink();
        }
        ?>


        <!-- entry -->
        <div class="entry">

            <?php the_content('Читать далее &raquo;'); ?>

            <?php
            # page 'grammar'
            if (is_page('2')) {

                $categories = get_pages(array('child_of' => 2, 'sort_column' => 'menu_order', 'sort_order' => 'ASC'));

                foreach ($categories as $category) {

                    if ($category->post_parent == 2) {

                        echo '                <h2 id="' . $category->post_name . '">' . $category->post_title . '</h2>' . "\n";

                        $pages = get_pages((array('child_of' => $category->ID, 'sort_column' => 'menu_order', 'sort_order' => 'ASC')));

                        if ($pages) {
                            echo '                <ul>' . "\n";
                            foreach ($pages as $page) {
                                echo '                    <li style="list-style-type: square; margin-left: 20px; margin-bottom: 10px;"><a href="' . get_bloginfo('url') . '/grammar/' . $category->post_name . '/' . $page->post_name . '/" title="' . $page->post_title . '" class="counter-hover">' . $page->post_title . '</a></li>' . "\n";
                            }
                            echo '                </ul>' . "\n";
                        }
                    }
                }
                
                
            }
            ?>

            <?php

            if ($parentCategory[0]->slug == 'news') {
                echo '<p> Дата: <span style="font-style: italic;">' . the_date('d-m-Y', '', '', FALSE) .'</span></p>';

                echo '<p>&larr; <a href="' . get_bloginfo('url') . '/news/" title="Новости английского языка"><strong>К списку новостей</strong></a></p>';

            }

            ?>

        </div>
        <!-- /entry -->

        <?php
            include("crosslinks.php");
        ?>

        <div class="social">

            <div id="vk_like"></div>
            <script type="text/javascript">
                VK.Widgets.Like("vk_like", {type: "button"});
                // _ga.trackVkontakte();
            </script>


            <div class="fb-like" data-send="false" data-layout="button_count" data-width="450" data-show-faces="true" data-font="arial"></div>


            <a href="https://twitter.com/share" class="twitter-share-button" data-via="englishstyleNET" data-lang="ru">Твитнуть</a>
            <script>!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0];if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src="//platform.twitter.com/widgets.js";fjs.parentNode.insertBefore(js,fjs);}}(document,"script","twitter-wjs");</script>


            <div class="g-plusone" data-size="medium"></div>

        </div>

    <?php endwhile; ?>

<?php else : ?>

    <h1>Страница не найдена</h1>
    
    <p><a href="<?php bloginfo('url'); ?>/" title="">Перейти на главную</a></p>

<?php endif; ?>

<?php #get_sidebar(); ?>
<?php get_footer(); ?>