<?php
/*
Plugin Name: Weekend reading related posts
Plugin URI: http://englishstyle.net
Description: Добавляет после записи "Что почитать на выходных" ссылки на другие записи этой рубрики
Version: 1.0
Author: dmitry
Author URI: http://englishstyle.net
License: GPL2
*/

// ini_set("display_errors", 1);
// error_reporting(E_ALL);

# TODO!

// 1. Вывод даты
// 2. Отключить текщий пост

add_filter('the_content', 'weekend_reading_related_posts');

function weekend_reading_related_posts($content) {

    if (has_tag('weekend-reading')) {

        $id = get_the_id();

        $loop = new WP_Query(
            array(
                'posts_per_page' => 3,
                'orderby' => 'date',
                'tag' => 'weekend-reading',
                'post__not_in' => array($id)
            )
        );

        if ( $loop->have_posts() ) {

            $content .= '<div style="margin-bottom: 15px; border-radius: 10px; background-color: #f2d6f5; padding: 15px 20px 5px 20px;">
            <h3>Другие выпуски "Что почитать на выходных":</h3>
            <ul>';

            while( $loop->have_posts() ) {
                $loop->the_post();
                $content .= '<li><a href="' . get_permalink() . '" title="' . get_the_title() . '">' . get_the_title() . '</a> (<em>' . get_the_date() . '</em>)</li>';
            }

            $content .= '</ul></div>';
            wp_reset_query();
        }

        return $content;
    }

    return $content;
}



?>